
from gurobipy import *

# Define the model
m = Model("Optimization_Model")

# Define variables
Laura_hours = m.addVar(name="Laura_hours", lb=0, vtype=GRB.CONTINUOUS)
Bobby_hours = m.addVar(name="Bobby_hours", lb=0, vtype=GRB.CONTINUOUS)
Peggy_hours = m.addVar(name="Peggy_hours", lb=0, vtype=GRB.CONTINUOUS)
Dale_hours = m.addVar(name="Dale_hours", lb=0, vtype=GRB.CONTINUOUS)
John_hours = m.addVar(name="John_hours", lb=0, vtype=GRB.CONTINUOUS)

# Objective function
m.setObjective(5 * Laura_hours + 7 * Bobby_hours + 1 * Peggy_hours + 3 * Dale_hours + 6 * John_hours, GRB.MAXIMIZE)

# Constraints

# Productivity rating constraints
m.addConstr(9 * Laura_hours + 20 * Dale_hours >= 57, name="Productivity_Laura_Dale")
m.addConstr(6 * Peggy_hours + 17 * John_hours >= 62, name="Productivity_Peggy_John")
m.addConstr(9 * Laura_hours + 17 * John_hours >= 53, name="Productivity_Laura_John")
m.addConstr(9 * Laura_hours + 6 * Peggy_hours + 17 * John_hours >= 44, name="Productivity_Laura_Peggy_John")
m.addConstr(15 * Bobby_hours + 6 * Peggy_hours + 17 * John_hours >= 44, name="Productivity_Bobby_Peggy_John")
m.addConstr(15 * Bobby_hours + 20 * Dale_hours + 17 * John_hours >= 44, name="Productivity_Bobby_Dale_John")
m.addConstr(9 * Laura_hours + 6 * Peggy_hours + 20 * Dale_hours + 17 * John_hours <= 120, name="Total_Productivity")

# Organization score constraints
m.addConstr(19 * Laura_hours + 11 * Peggy_hours <= 411, name="Organization_Laura_Peggy")
m.addConstr(11 * Peggy_hours + 16 * Dale_hours <= 276, name="Organization_Peggy_Dale")
m.addConstr(21 * Bobby_hours + 13 * John_hours <= 422, name="Organization_Bobby_John")
m.addConstr(16 * Dale_hours + 13 * John_hours <= 268, name="Organization_Dale_John")
m.addConstr(21 * Bobby_hours + 16 * Dale_hours <= 409, name="Organization_Bobby_Dale")
m.addConstr(11 * Peggy_hours + 13 * John_hours <= 688, name="Organization_Peggy_John")
m.addConstr(19 * Laura_hours + 21 * Bobby_hours + 11 * Peggy_hours + 16 * Dale_hours + 13 * John_hours <= 688, name="Total_Organization")

# Other constraints
m.addConstr(3 * Bobby_hours - 3 * Peggy_hours >= 0, name="Bobby_Peggy_Constraint")
m.addConstr(9 * Laura_hours + 17 * John_hours <= 171, name="Laura_John_Productivity")
m.addConstr(15 * Bobby_hours + 20 * Dale_hours <= 120, name="Bobby_Dale_Productivity")

# Solve the model
m.optimize()
