
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Laura", lb=0)
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x2 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x3 = m.addVar(name="hours_worked_by_Dale", lb=0)
x4 = m.addVar(name="hours_worked_by_John", lb=0)

# Define the objective function
m.setObjective(5 * x0 + 7 * x1 + x2 + 3 * x3 + 6 * x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * x0 + 20 * x3 >= 57)
m.addConstr(6 * x2 + 17 * x4 >= 62)
m.addConstr(9 * x0 + 17 * x4 >= 53)
m.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 44)
m.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 44)
m.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 44)
m.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 44)
m.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 54)
m.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 54)
m.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 54)
m.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 54)
m.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 50)
m.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 50)
m.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 50)
m.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 50)
m.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 60)
m.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 60)
m.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 60)
m.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 60)
m.addConstr(5 * x1 + 11 * x2 >= 150)
m.addConstr(19 * x0 + 11 * x3 >= 75)
m.addConstr(19 * x0 + 6 * x4 >= 104)
m.addConstr(5 * x1 + 11 * x3 >= 117)
m.addConstr(19 * x0 + 5 * x1 >= 79)
m.addConstr(19 * x0 + 5 * x1 + 11 * x3 >= 147)
m.addConstr(19 * x0 + 11 * x2 + 11 * x3 >= 147)
m.addConstr(11 * x2 + 11 * x3 + 6 * x4 >= 147)
m.addConstr(5 * x1 + 11 * x2 + 11 * x3 >= 147)
m.addConstr(19 * x0 + 11 * x2 + 6 * x4 >= 147)
m.addConstr(5 * x1 + 11 * x2 + 6 * x4 >= 147)
m.addConstr(19 * x0 + 5 * x1 + 11 * x2 >= 147)
m.addConstr(19 * x0 + 11 * x3 + 6 * x4 >= 147)
m.addConstr(5 * x1 - 3 * x2 >= 0)
m.addConstr(9 * x0 + 17 * x4 <= 171)
m.addConstr(15 * x1 + 20 * x3 <= 120)
m.addConstr(9 * x0 + 15 * x1 + 6 * x2 + 20 * x3 + 17 * x4 <= 120)
m.addConstr(19 * x0 + 11 * x2 <= 411)
m.addConstr(11 * x2 + 11 * x3 <= 276)
m.addConstr(5 * x1 + 6 * x4 <= 422)
m.addConstr(11 * x3 + 6 * x4 <= 268)
m.addConstr(5 * x1 + 11 * x3 <= 409)
m.addConstr(11 * x2 + 6 * x4 <= 688)
m.addConstr(19 * x0 + 5 * x1 + 11 * x2 + 11 * x3 + 6 * x4 <= 688)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x0.varValue)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
    print("Hours worked by John: ", x4.varValue)
else:
    print("The model is infeasible")
