
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b3 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b3")
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")

# Set objective function
m.setObjective(7 * vitamin_b3 + 4 * vitamin_a + 7 * iron + 8 * vitamin_d, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.04 * vitamin_b3 + 1.01 * iron >= 12)
m.addConstr(0.21 * vitamin_a + 1.01 * iron >= 14)
m.addConstr(1.04 * vitamin_b3 + 0.21 * vitamin_a >= 15)
m.addConstr(0.21 * vitamin_a + 0.23 * vitamin_d >= 30)
m.addConstr(1.04 * vitamin_b3 + 0.21 * vitamin_a + 0.23 * vitamin_d >= 27)

m.addConstr(0.87 * iron + 1.64 * vitamin_d >= 15)
m.addConstr(0.27 * vitamin_b3 + 1.64 * vitamin_d >= 33)
m.addConstr(1.39 * vitamin_a + 1.64 * vitamin_d >= 19)
m.addConstr(1.39 * vitamin_a + 0.87 * iron >= 24)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a >= 15)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 1.64 * vitamin_d >= 30)
m.addConstr(0.27 * vitamin_b3 + 0.87 * iron + 1.64 * vitamin_d >= 30)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 0.87 * iron >= 30)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 1.64 * vitamin_d >= 34)
m.addConstr(0.27 * vitamin_b3 + 0.87 * iron + 1.64 * vitamin_d >= 34)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 0.87 * iron >= 34)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 1.64 * vitamin_d >= 33)
m.addConstr(0.27 * vitamin_b3 + 0.87 * iron + 1.64 * vitamin_d >= 33)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 0.87 * iron >= 33)


m.addConstr(0.21 * vitamin_a + 1.01 * iron <= 40)
m.addConstr(0.21 * vitamin_a + 0.23 * vitamin_d <= 110)
m.addConstr(1.04 * vitamin_b3 + 1.01 * iron <= 58)
m.addConstr(1.04 * vitamin_b3 + 0.21 * vitamin_a + 1.01 * iron + 0.23 * vitamin_d <= 58)

m.addConstr(0.27 * vitamin_b3 + 0.87 * iron <= 108)
m.addConstr(1.39 * vitamin_a + 1.64 * vitamin_d <= 60)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a <= 53)
m.addConstr(1.39 * vitamin_a + 0.87 * iron <= 53)
m.addConstr(0.87 * iron + 1.64 * vitamin_d <= 93)
m.addConstr(0.27 * vitamin_b3 + 0.87 * iron + 1.64 * vitamin_d <= 46)
m.addConstr(0.27 * vitamin_b3 + 1.39 * vitamin_a + 0.87 * iron + 1.64 * vitamin_d <= 46)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b3:', vitamin_b3.x)
    print('vitamin_a:', vitamin_a.x)
    print('iron:', iron.x)
    print('vitamin_d:', vitamin_d.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

