
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="vitamin_B3", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B3
x1 = m.addVar(name="vitamin_A", vtype=gp.GRB.INTEGER)  # milligrams of vitamin A
x2 = m.addVar(name="iron", vtype=gp.GRB.CONTINUOUS)  # milligrams of iron
x3 = m.addVar(name="vitamin_D", vtype=gp.GRB.CONTINUOUS)  # milligrams of vitamin D

# Objective function
m.setObjective(7 * x0 + 4 * x1 + 7 * x2 + 8 * x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1.04 * x0 <= 123)
m.addConstr(0.27 * x0 <= 137)
m.addConstr(0.21 * x1 <= 123)
m.addConstr(1.39 * x1 <= 137)
m.addConstr(1.01 * x2 <= 123)
m.addConstr(0.87 * x2 <= 137)
m.addConstr(0.23 * x3 <= 123)
m.addConstr(1.64 * x3 <= 137)

m.addConstr(1.04 * x0 + 1.01 * x2 >= 12)
m.addConstr(0.21 * x1 + 1.01 * x2 >= 14)
m.addConstr(1.04 * x0 + 0.21 * x1 >= 15)
m.addConstr(0.21 * x1 + 0.23 * x3 >= 30)
m.addConstr(1.04 * x0 + 0.21 * x1 + 0.23 * x3 >= 27)
m.addConstr(0.87 * x2 + 1.64 * x3 >= 15)
m.addConstr(0.27 * x0 + 1.64 * x3 >= 33)
m.addConstr(1.39 * x1 + 1.64 * x3 >= 19)
m.addConstr(1.39 * x1 + 0.87 * x2 >= 24)
m.addConstr(0.27 * x0 + 1.39 * x1 >= 15)
m.addConstr(0.27 * x0 + 1.39 * x1 + 1.64 * x3 >= 30)
m.addConstr(0.27 * x0 + 0.87 * x2 + 1.64 * x3 >= 30)
m.addConstr(0.27 * x0 + 1.39 * x1 + 0.87 * x2 >= 30)
m.addConstr(0.27 * x0 + 1.39 * x1 + 1.64 * x3 >= 34)
m.addConstr(0.27 * x0 + 0.87 * x2 + 1.64 * x3 >= 34)
m.addConstr(0.27 * x0 + 1.39 * x1 + 0.87 * x2 >= 34)
m.addConstr(0.27 * x0 + 1.39 * x1 + 1.64 * x3 >= 33)
m.addConstr(0.27 * x0 + 0.87 * x2 + 1.64 * x3 >= 33)
m.addConstr(0.27 * x0 + 1.39 * x1 + 0.87 * x2 >= 33)

m.addConstr(0.21 * x1 + 1.01 * x2 <= 40)
m.addConstr(0.21 * x1 + 0.23 * x3 <= 110)
m.addConstr(1.04 * x0 + 1.01 * x2 <= 58)
m.addConstr(1.04 * x0 + 0.21 * x1 + 1.01 * x2 + 0.23 * x3 <= 58)
m.addConstr(0.27 * x0 + 0.87 * x2 <= 108)
m.addConstr(1.39 * x1 + 1.64 * x3 <= 60)
m.addConstr(0.27 * x0 + 1.39 * x1 <= 53)
m.addConstr(1.39 * x1 + 0.87 * x2 <= 53)
m.addConstr(0.87 * x2 + 1.64 * x3 <= 93)
m.addConstr(0.27 * x0 + 0.87 * x2 + 1.64 * x3 <= 46)
m.addConstr(0.27 * x0 + 1.39 * x1 + 0.87 * x2 + 1.64 * x3 <= 46)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin B3: {x0.varValue}")
    print(f"Vitamin A: {x1.varValue}")
    print(f"Iron: {x2.varValue}")
    print(f"Vitamin D: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
