
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrient Optimization")

# Create variables
zinc = model.addVar(nonnegative=True, name="zinc")
vitamin_b6 = model.addVar(nonnegative=True, name="vitamin_b6")

# Set objective function
model.setObjective(8.82 * zinc + 1.66 * vitamin_b6, GRB.MAXIMIZE)

# Add constraints
model.addConstr(26 * zinc + 29 * vitamin_b6 >= 85, "kidney_support_min")
model.addConstr(7 * zinc + 4 * vitamin_b6 >= 60, "cardiovascular_support_min")
model.addConstr(28 * zinc + 7 * vitamin_b6 >= 24, "cognitive_performance_min")
model.addConstr(-6 * zinc + 4 * vitamin_b6 >= 0, "zinc_b6_ratio")
model.addConstr(26 * zinc + 29 * vitamin_b6 <= 158, "kidney_support_max")
model.addConstr(7 * zinc + 4 * vitamin_b6 <= 119, "cardiovascular_support_max")
model.addConstr(28 * zinc + 7 * vitamin_b6 <= 89, "cognitive_performance_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of zinc: {zinc.x}")
    print(f"Milligrams of vitamin B6: {vitamin_b6.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

