
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_e")
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_d")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="magnesium")

    # Set objective function
    m.setObjective(5.44 * fiber + 8.62 * vitamin_e + 9.19 * vitamin_b9 + 5.25 * potassium + 3.47 * vitamin_d + 3.21 * magnesium, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * vitamin_b9 + 7 * magnesium >= 13)
    m.addConstr(11 * vitamin_e + 7 * magnesium >= 7)
    m.addConstr(2 * fiber + 9 * potassium >= 13)
    m.addConstr(11 * vitamin_e + 8 * vitamin_d >= 23)
    m.addConstr(11 * vitamin_e + 4 * vitamin_b9 >= 16)
    m.addConstr(4 * vitamin_b9 + 9 * potassium >= 19)
    m.addConstr(2 * fiber + 7 * magnesium >= 11)
    m.addConstr(2 * fiber + 8 * vitamin_d >= 19)
    m.addConstr(2 * fiber + 11 * vitamin_e >= 17)
    m.addConstr(8 * vitamin_d + 7 * magnesium >= 17)
    m.addConstr(11 * vitamin_e + 9 * potassium >= 17)
    m.addConstr(9 * potassium + 8 * vitamin_d >= 20)
    m.addConstr(2 * fiber + 11 * vitamin_e + 7 * magnesium >= 22)
    m.addConstr(11 * vitamin_e + 4 * vitamin_b9 + 9 * potassium >= 22)
    m.addConstr(11 * vitamin_e + 8 * vitamin_d + 7 * magnesium >= 22)
    m.addConstr(9 * potassium + 8 * vitamin_d + 7 * magnesium >= 22)
    m.addConstr(2 * fiber + 11 * vitamin_e + 8 * vitamin_d >= 22)
    m.addConstr(4 * vitamin_b9 + 9 * potassium + 8 * vitamin_d >= 22)
    m.addConstr(11 * vitamin_e + 9 * potassium + 7 * magnesium >= 22)
    m.addConstr(2 * fiber + 8 * vitamin_d + 7 * magnesium >= 22)
    m.addConstr(2 * fiber + 11 * vitamin_e + 4 * vitamin_b9 >= 22)
    m.addConstr(2 * fiber + 4 * vitamin_b9 + 8 * vitamin_d >= 22)
    m.addConstr(4 * vitamin_b9 + 9 * potassium + 7 * magnesium >= 22)
    m.addConstr(11 * vitamin_e + 4 * vitamin_b9 + 8 * vitamin_d >= 22)

    #Simplified/removed redundant constraints below this line

    m.addConstr(2 * vitamin_b9 - 9 * potassium >= 0)
    m.addConstr(2 * vitamin_d - 3 * magnesium >= 0)
    m.addConstr(10 * vitamin_e - 9 * vitamin_d >= 0)
    m.addConstr(9 * potassium + 8 * vitamin_d <= 31)
    m.addConstr(2 * fiber + 8 * vitamin_d <= 72)
    m.addConstr(4 * vitamin_b9 + 9 * potassium <= 134)
    m.addConstr(2 * fiber + 4 * vitamin_b9 <= 48)
    m.addConstr(2 * fiber + 9 * potassium <= 52)
    m.addConstr(8 * vitamin_d + 7 * magnesium <= 94)
    m.addConstr(2 * fiber + 7 * magnesium <= 103)
    m.addConstr(2 * fiber + 11 * vitamin_e + 4 * vitamin_b9 + 9 * potassium + 8 * vitamin_d + 7 * magnesium >= 15)


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
