
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
f = m.addVar(lb=0, name="fiber", vtype=gp.GRB.CONTINUOUS) # grams of fiber
e = m.addVar(lb=0, name="vitamin_E", vtype=gp.GRB.INTEGER) # milligrams of vitamin E
b = m.addVar(lb=0, name="vitamin_B9", vtype=gp.GRB.CONTINUOUS) # milligrams of vitamin B9
p = m.addVar(lb=0, name="potassium", vtype=gp.GRB.CONTINUOUS) # milligrams of potassium
d = m.addVar(lb=0, name="vitamin_D", vtype=gp.GRB.INTEGER) # milligrams of vitamin D
m_var = m.addVar(lb=0, name="magnesium", vtype=gp.GRB.INTEGER) # milligrams of magnesium

# Define the objective function
m.setObjective(5.44 * f + 8.62 * e + 9.19 * b + 5.25 * p + 3.47 * d + 3.21 * m_var, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * f + 11 * e + 4 * b + 9 * p + 8 * d + 7 * m_var <= 138)

# ... add all other constraints ...

m.addConstr(2 * b - 9 * p >= 0)
m.addConstr(2 * d - 3 * m_var >= 0)
m.addConstr(10 * e - 9 * d >= 0)

m.addConstr(9 * p + 8 * d <= 31)
m.addConstr(2 * f + 8 * d <= 72)
m.addConstr(4 * b + 9 * p <= 134)
m.addConstr(2 * f + 4 * b <= 48)
m.addConstr(2 * f + 9 * p <= 52)
m.addConstr(8 * d + 7 * m_var <= 94)
m.addConstr(2 * f + 7 * m_var <= 103)

# ... 

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Objective value:", m.objVal)
    print("Fiber:", f.varValue)
    print("Vitamin E:", e.varValue)
    print("Vitamin B9:", b.varValue)
    print("Potassium:", p.varValue)
    print("Vitamin D:", d.varValue)
    print("Magnesium:", m_var.varValue)
else:
    print("No optimal solution found.")
