
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables for hours worked by each person
Jean = m.addVar(vtype=GRB.CONTINUOUS, name="Jean")
Peggy = m.addVar(vtype=GRB.CONTINUOUS, name="Peggy")
Bill = m.addVar(vtype=GRB.CONTINUOUS, name="Bill")
John = m.addVar(vtype=GRB.CONTINUOUS, name="John")
Dale = m.addVar(vtype=GRB.CONTINUOUS, name="Dale")
Laura = m.addVar(vtype=GRB.CONTINUOUS, name="Laura")
Mary = m.addVar(vtype=GRB.CONTINUOUS, name="Mary")
George = m.addVar(vtype=GRB.CONTINUOUS, name="George")

# Example constraint: Total hours worked by Jean and Peggy should not exceed 100
m.addConstr(Jean + Peggy <= 100, "Total Hours Constraint")

# Another example constraint: Productivity rating of Bill and John combined should be less than or equal to 200
# Assuming a productivity rate per hour for simplicity (this is hypothetical as actual rates are not provided)
m.addConstr(10*Bill + 15*John <= 200, "Productivity Constraint")

# Objective function example: Maximize the total hours worked by all employees
m.setObjective(Jean + Peggy + Bill + John + Dale + Laura + Mary + George, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print out the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
