
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrient_optimization")

# Create variables
iron = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
vitamin_c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_c")
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")

# Set objective function
model.setObjective(1.3 * iron + 6.78 * vitamin_c + 8.38 * fiber, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * vitamin_c + 6 * fiber >= 78, "kidney_constraint1")
model.addConstr(33 * iron + 6 * fiber <= 331, "kidney_constraint2")
model.addConstr(2 * vitamin_c + 6 * fiber <= 166, "kidney_constraint3")
model.addConstr(33 * iron + 2 * vitamin_c + 6 * fiber <= 166, "kidney_constraint4")

model.addConstr(4 * vitamin_c + 25 * fiber <= 87, "cognitive_constraint1")
model.addConstr(6 * iron + 4 * vitamin_c <= 113, "cognitive_constraint2")
model.addConstr(6 * iron + 4 * vitamin_c + 25 * fiber <= 113, "cognitive_constraint3")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Iron: %g' % iron.x)
    print('Vitamin C: %g' % vitamin_c.x)
    print('Fiber: %g' % fiber.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

