
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
iron = m.addVar(name="iron", lb=0)  # milligrams of iron
vitamin_c = m.addVar(name="vitamin_c", lb=0)  # milligrams of vitamin C
fiber = m.addVar(name="fiber", lb=0)  # grams of fiber

# Objective function
m.setObjective(1.3 * iron + 6.78 * vitamin_c + 8.38 * fiber, gp.GRB.MAXIMIZE)

# Constraints
m.addConstraint(2 * vitamin_c + 6 * fiber >= 78)  # Kidney support index constraint 1
m.addConstraint(33 * iron + 6 * fiber <= 331)  # Kidney support index constraint 2
m.addConstraint(2 * vitamin_c + 6 * fiber <= 166)  # Kidney support index constraint 3
m.addConstraint(33 * iron + 2 * vitamin_c + 6 * fiber <= 166)  # Kidney support index constraint 4
m.addConstraint(4 * vitamin_c + 25 * fiber <= 87)  # Cognitive performance index constraint 1
m.addConstraint(6 * iron + 4 * vitamin_c <= 113)  # Cognitive performance index constraint 2
m.addConstraint(6 * iron + 4 * vitamin_c + 25 * fiber <= 113)  # Cognitive performance index constraint 3

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Iron: {iron.varValue} milligrams")
    print(f"Vitamin C: {vitamin_c.varValue} milligrams")
    print(f"Fiber: {fiber.varValue} grams")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
