
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vit_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vit_k")

# Set objective function
m.setObjective(8 * carbs + 3 * zinc + 2 * vit_k, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12.5 * carbs + 19.96 * zinc + 12.75 * vit_k >= 58, "cpi_min")
m.addConstr(11.97 * carbs + 20.9 * zinc + 6.86 * vit_k >= 79, "ksi_min")
m.addConstr(-zinc + vit_k >= 0, "zinc_vitk_relation")
m.addConstr(12.5 * carbs + 19.96 * zinc <= 132, "cpi_carbs_zinc_max")
m.addConstr(19.96 * zinc + 12.75 * vit_k <= 145, "cpi_zinc_vitk_max")
m.addConstr(12.5 * carbs + 19.96 * zinc + 12.75 * vit_k <= 90, "cpi_total_max1") # Redundant constraint, same as next one
m.addConstr(12.5 * carbs + 19.96 * zinc + 12.75 * vit_k <= 90, "cpi_total_max2")
m.addConstr(20.9 * zinc + 6.86 * vit_k <= 236, "ksi_zinc_vitk_max")
m.addConstr(11.97 * carbs + 20.9 * zinc <= 251, "ksi_carbs_zinc_max")
m.addConstr(11.97 * carbs + 20.9 * zinc + 6.86 * vit_k <= 251, "ksi_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('carbs:', carbs.x)
    print('zinc:', zinc.x)
    print('vit_k:', vit_k.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

