
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams_of_carbohydrates")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_zinc")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_K")

    # Objective function
    model.setObjective(8 * x0 + 3 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    # 7. Total cognitive performance index >= 58
    model.addConstr(12.5 * x0 + 19.96 * x1 + 12.75 * x2 >= 58, name="cognitive_performance_index_total")

    # 8. Total kidney support index >= 79
    model.addConstr(11.97 * x0 + 20.9 * x1 + 6.86 * x2 >= 79, name="kidney_support_index_total")

    # 9. -milligrams of zinc + milligrams of vitamin K >= 0
    model.addConstr(-x1 + x2 >= 0, name="zinc_vitamin_K_constraint")

    # 10. Total cognitive performance index of grams of carbohydrates and milligrams of zinc <= 132
    model.addConstr(12.5 * x0 + 19.96 * x1 <= 132, name="cognitive_performance_index_carbohydrates_zinc")

    # 11. Total cognitive performance index of milligrams of zinc and milligrams of vitamin K <= 145
    model.addConstr(19.96 * x1 + 12.75 * x2 <= 145, name="cognitive_performance_index_zinc_vitamin_K")

    # 12 & 13. Total cognitive performance index of all <= 90 and equals 90
    model.addConstr(12.5 * x0 + 19.96 * x1 + 12.75 * x2 <= 90, name="cognitive_performance_index_all")
    model.addConstr(12.5 * x0 + 19.96 * x1 + 12.75 * x2 == 90, name="cognitive_performance_index_all_exact")

    # 14. Total kidney support index of milligrams of zinc and milligrams of vitamin K <= 236
    model.addConstr(20.9 * x1 + 6.86 * x2 <= 236, name="kidney_support_index_zinc_vitamin_K")

    # 15. Total kidney support index of grams of carbohydrates and milligrams of zinc <= 251
    model.addConstr(11.97 * x0 + 20.9 * x1 <= 251, name="kidney_support_index_carbohydrates_zinc")

    # 16. Total kidney support index of all <= 251
    model.addConstr(11.97 * x0 + 20.9 * x1 + 6.86 * x2 <= 251, name="kidney_support_index_all")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of carbohydrates: {x0.varValue}")
        print(f"Milligrams of zinc: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
