
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
P = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")
M = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
J = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")

# Objective function
m.setObjective(8*P + 2*M + 3*J, GRB.MINIMIZE)

# Constraints
m.addConstr(9*M + J >= 7, "dollar_cost_MJ")
m.addConstr(12*P + 9*M + J >= 7, "total_dollar_cost")
m.addConstr(2*P + M >= 10, "productivity_PM")
m.addConstr(M + 10*J >= 13, "productivity_MJ")
m.addConstr(2*P + 10*J >= 16, "productivity_PJ")
m.addConstr(2*P + M + 10*J >= 16, "total_productivity")
m.addConstr(-8*P + 5*M >= 0, "constraint_13")
m.addConstr(8*M - 7*J >= 0, "constraint_14")
m.addConstr(2*P + M <= 32, "max_productivity_PM")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {P.x}")
    print(f"Hours worked by Mary: {M.x}")
    print(f"Hours worked by Jean: {J.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
