
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    P = model.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy
    M = model.addVar(name="hours_worked_by_Mary", lb=0)   # hours worked by Mary
    J = model.addVar(name="hours_worked_by_Jean", lb=0)   # hours worked by Jean

    # Define the objective function
    model.setObjective(8 * P + 2 * M + 3 * J, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(12 * P + 9 * M + J >= 7, name="total_dollar_cost")
    model.addConstr(2 * P + M >= 10, name="productivity_rating_Peggy_Mary")
    model.addConstr(M + 10 * J >= 13, name="productivity_rating_Mary_Jean")
    model.addConstr(2 * P + 10 * J >= 16, name="productivity_rating_Peggy_Jean")
    model.addConstr(2 * P + M + 10 * J >= 16, name="productivity_rating_all")
    model.addConstr(-8 * P + 5 * M >= 0, name="Peggy_Mary_tradeoff")
    model.addConstr(8 * M - 7 * J >= 0, name="Mary_Jean_tradeoff")
    model.addConstr(2 * P + M <= 32, name="productivity_rating_Peggy_Mary_max")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {P.varValue}")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by Jean: {J.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
