
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B1")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B7", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of carbohydrates")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of fiber")

    # Objective function
    model.setObjective(8 * x0 + x1 + x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.98 * x1 + 0.33 * x2 + 1.43 * x3 + 1.31 * x0 >= 44, name="kidney_support_index_total_min")
    model.addConstr(0.85 * x0 + 1.8 * x2 >= 60, name="muscle_growth_index_B1_carbohydrates_min")
    model.addConstr(1.8 * x2 + 1.16 * x3 >= 49, name="muscle_growth_index_carbohydrates_fiber_min")
    model.addConstr(0.85 * x0 + 1.16 * x3 >= 56, name="muscle_growth_index_B1_fiber_min")
    model.addConstr(0.85 * x0 + 0.04 * x1 + 1.8 * x2 + 1.16 * x3 >= 56, name="muscle_growth_index_total_min")
    model.addConstr(9 * x2 - 9 * x3 >= 0, name="carbohydrates_fiber_balance")
    model.addConstr(-2 * x1 + 9 * x3 >= 0, name="vitamin_B7_fiber_balance")
    model.addConstr(1.31 * x0 + 0.33 * x2 <= 76, name="kidney_support_index_B1_carbohydrates_max")
    model.addConstr(0.33 * x2 + 1.43 * x3 <= 191, name="kidney_support_index_carbohydrates_fiber_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of vitamin B1: {x0.varValue}")
        print(f"Milligrams of vitamin B7: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Grams of fiber: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The problem has a non-optimal status.")

solve_optimization_problem()
