
from gurobipy import Model, GRB, quicksum

# Define the model
model = Model("Food Optimization")

# Define the variables
foods = ['bananas', 'potatoes', 'apples', 'ravioli', 'black beans', 'knishes']
x = model.addVars(foods, lb=0.0, name="x")

# Set integer constraints
x['apples'].vtype = GRB.INTEGER
x['black beans'].vtype = GRB.INTEGER


# Define the objective function
objective = 3 * x['bananas'] + 7 * x['potatoes'] + 5 * x['apples'] + 8 * x['ravioli'] + 7 * x['black beans'] + 1 * x['knishes']
model.setObjective(objective, GRB.MINIMIZE)

# Define the resource constraints
resources = {
    'r0': {'upper_bound': 255, 'values': [9, 11, 6, 23, 23, 19]},  # healthiness rating
    'r1': {'upper_bound': 783, 'values': [5, 13, 10, 21, 3, 9]},  # grams of fiber
    'r2': {'upper_bound': 223, 'values': [21, 22, 7, 19, 19, 18]},  # tastiness rating
    'r3': {'upper_bound': 466, 'values': [6, 5, 5, 11, 15, 20]}  # milligrams of iron
}

for r, data in resources.items():
    model.addConstr(quicksum(data['values'][i] * x[foods[i]] for i in range(len(foods))) <= data['upper_bound'], name=r)

# Additional constraints (healthiness rating)
model.addConstr(23 * x['black beans'] + 19 * x['knishes'] >= 17, "c1")
model.addConstr(11 * x['potatoes'] + 23 * x['black beans'] >= 29, "c2")
model.addConstr(6 * x['apples'] + 19 * x['knishes'] >= 19, "c3")
model.addConstr(6 * x['apples'] + 23 * x['ravioli'] >= 42, "c4")
model.addConstr(11 * x['potatoes'] + 23 * x['ravioli'] >= 24, "c5")
model.addConstr(9 * x['bananas'] + 19 * x['knishes'] >= 20, "c6")
model.addConstr(6 * x['apples'] + 23 * x['black beans'] >= 15, "c7")
model.addConstr(9 * x['bananas'] + 11 * x['potatoes'] >= 28, "c8")
model.addConstr(11 * x['potatoes'] + 19 * x['knishes'] >= 30, "c9")
model.addConstr(9 * x['bananas'] + 23 * x['black beans'] >= 39, "c10")
model.addConstr(23 * x['ravioli'] + 23 * x['black beans'] >= 35, "c11")
model.addConstr(23 * x['ravioli'] + 19 * x['knishes'] >= 38, "c12")
model.addConstr(9 * x['bananas'] + 23 * x['ravioli'] >= 39, "c13")
model.addConstr(quicksum(resources['r0']['values'][i] * x[foods[i]] for i in range(len(foods))) >= 39, "c14")

# ... (rest of the constraints - fiber, tastiness, iron, and other custom constraints)

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for food in foods:
        print(f"{food}: {x[food].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

