
import gurobi as gp

# Define the variables
model = gp.Model("optimization_problem")

bananas = model.addVar(lb=0, name="bananas", vtype=gp.GRB.CONTINUOUS)
potatoes = model.addVar(lb=0, name="potatoes", vtype=gp.GRB.CONTINUOUS)
apples = model.addVar(lb=0, name="apples", vtype=gp.GRB.INTEGER)
ravioli = model.addVar(lb=0, name="ravioli", vtype=gp.GRB.CONTINUOUS)
black_beans = model.addVar(lb=0, name="black_beans", vtype=gp.GRB.INTEGER)
knishes = model.addVar(lb=0, name="knishes", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(3 * bananas + 7 * potatoes + 5 * apples + 8 * ravioli + 7 * black_beans + 1 * knishes, gp.GRB.MINIMIZE)

# Add healthiness rating constraints
model.addConstraint(9 * bananas + 11 * potatoes + 6 * apples + 23 * ravioli + 23 * black_beans + 19 * knishes <= 255)
model.addConstraint(9 * bananas + 11 * potatoes >= 29)
model.addConstraint(6 * apples + 19 * knishes >= 19)
model.addConstraint(6 * apples + 23 * ravioli >= 42)
model.addConstraint(11 * potatoes + 23 * ravioli >= 24)
model.addConstraint(9 * bananas + 19 * knishes >= 20)
model.addConstraint(6 * apples + 23 * black_beans >= 15)
model.addConstraint(9 * bananas + 11 * potatoes >= 28)
model.addConstraint(11 * potatoes + 19 * knishes >= 30)
model.addConstraint(9 * bananas + 23 * black_beans >= 39)
model.addConstraint(23 * ravioli + 23 * black_beans >= 35)
model.addConstraint(23 * ravioli + 19 * knishes >= 38)
model.addConstraint(9 * bananas + 23 * ravioli >= 39)
model.addConstraint(9 * bananas + 11 * potatoes + 6 * apples + 23 * ravioli + 23 * black_beans + 19 * knishes >= 39)

model.addConstraint(5 * ravioli + 9 * knishes >= 122)
model.addConstraint(13 * potatoes + 3 * black_beans >= 94)
model.addConstraint(5 * bananas + 3 * black_beans + 9 * knishes >= 68)

model.addConstraint(19 * ravioli + 19 * black_beans >= 26)
model.addConstraint(7 * apples + 18 * knishes >= 30)

model.addConstraint(5 * apples + 11 * ravioli >= 25)

model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Bananas:", bananas.varValue)
    print("Potatoes:", potatoes.varValue)
    print("Apples:", apples.varValue)
    print("Ravioli:", ravioli.varValue)
    print("Black Beans:", black_beans.varValue)
    print("Knishes:", knishes.varValue)
    print("Objective:", model.objVal)
else:
    print("No optimal solution found.")
