
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Scheduling")

# Create variables
bobby_hours = model.addVar(vtype=GRB.INTEGER, name="bobby_hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="mary_hours")
ringo_hours = model.addVar(vtype=GRB.INTEGER, name="ringo_hours")

# Set objective function
model.setObjective(4 * bobby_hours + 7 * mary_hours + 8 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * bobby_hours + 2 * mary_hours >= 14, "paperwork_bobby_mary")
model.addConstr(2 * mary_hours + 16 * ringo_hours >= 30, "paperwork_mary_ringo")
model.addConstr(3 * bobby_hours + 16 * ringo_hours >= 28, "paperwork_bobby_ringo")
model.addConstr(3 * bobby_hours + 2 * mary_hours + 16 * ringo_hours >= 28, "paperwork_all")

model.addConstr(11 * bobby_hours + 13 * ringo_hours >= 37, "quit_bobby_ringo")
model.addConstr(3 * mary_hours + 13 * ringo_hours >= 32, "quit_mary_ringo")
model.addConstr(11 * bobby_hours + 3 * mary_hours + 13 * ringo_hours >= 32, "quit_all")

model.addConstr(13 * bobby_hours + 5 * mary_hours >= 44, "computer_bobby_mary")
model.addConstr(13 * bobby_hours + 5 * mary_hours + 15 * ringo_hours >= 44, "computer_all")

model.addConstr(-4 * bobby_hours + 7 * mary_hours >= 0, "bobby_mary_ratio")

model.addConstr(3 * bobby_hours + 16 * ringo_hours <= 80, "paperwork_bobby_ringo_max")
model.addConstr(3 * mary_hours + 13 * ringo_hours <= 103, "quit_mary_ringo_max")
model.addConstr(11 * bobby_hours + 13 * ringo_hours <= 53, "quit_bobby_ringo_max")
model.addConstr(11 * bobby_hours + 3 * mary_hours + 13 * ringo_hours <= 99, "quit_all_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
