
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Ringo", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 4*x0 + 7*x1 + 8*x2
    model.setObjective(4*x0 + 7*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x0 <= 112)
    model.addConstr(11*x0 <= 114)
    model.addConstr(13*x0 <= 140)
    model.addConstr(2*x1 <= 112)
    model.addConstr(3*x1 <= 114)
    model.addConstr(5*x1 <= 140)
    model.addConstr(16*x2 <= 112)
    model.addConstr(13*x2 <= 114)
    model.addConstr(15*x2 <= 140)
    model.addConstr(3*x0 + 2*x1 >= 14)
    model.addConstr(2*x1 + 16*x2 >= 30)
    model.addConstr(3*x0 + 16*x2 >= 28)
    model.addConstr(3*x0 + 2*x1 + 16*x2 >= 28)
    model.addConstr(11*x0 + 13*x2 >= 37)
    model.addConstr(3*x1 + 13*x2 >= 32)
    model.addConstr(11*x0 + 3*x1 + 13*x2 >= 32)
    model.addConstr(13*x0 + 5*x1 >= 44)
    model.addConstr(13*x0 + 5*x1 + 15*x2 >= 44)
    model.addConstr(-4*x0 + 7*x1 >= 0)
    model.addConstr(3*x0 + 16*x2 <= 80)
    model.addConstr(3*x1 + 13*x2 <= 103)
    model.addConstr(11*x0 + 13*x2 <= 53)
    model.addConstr(11*x0 + 3*x1 + 13*x2 <= 99)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bobby: {x0.varValue}")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
