
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
vincas = m.addVar(vtype=GRB.INTEGER, name="vincas")
cucumber_vines = m.addVar(vtype=GRB.INTEGER, name="cucumber_vines")
zucchini_vines = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
strawberry_bushes = m.addVar(vtype=GRB.INTEGER, name="strawberry_bushes")
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")

# Set objective function
m.setObjective(2.86 * vincas + 9.94 * cucumber_vines + 7.11 * zucchini_vines + 9.07 * strawberry_bushes + 2.48 * orange_trees, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * vincas + 3 * orange_trees >= 10)
m.addConstr(7 * zucchini_vines + 8 * strawberry_bushes >= 15)
m.addConstr(4 * vincas + 6 * cucumber_vines >= 19)
m.addConstr(6 * cucumber_vines + 3 * orange_trees >= 19)
m.addConstr(4 * vincas + 8 * strawberry_bushes >= 17)
m.addConstr(4 * vincas + 7 * zucchini_vines + 8 * strawberry_bushes >= 18)
m.addConstr(4 * vincas + 6 * cucumber_vines + 8 * strawberry_bushes >= 18)
m.addConstr(6 * cucumber_vines + 8 * strawberry_bushes + 3 * orange_trees >= 18)
m.addConstr(4 * vincas + 8 * strawberry_bushes + 3 * orange_trees >= 18)
m.addConstr(4 * vincas + 7 * zucchini_vines + 8 * strawberry_bushes >= 17)
m.addConstr(4 * vincas + 6 * cucumber_vines + 8 * strawberry_bushes >= 17)
m.addConstr(6 * cucumber_vines + 8 * strawberry_bushes + 3 * orange_trees >= 17)
m.addConstr(4 * vincas + 8 * strawberry_bushes + 3 * orange_trees >= 17)
m.addConstr(4 * vincas + 7 * zucchini_vines + 8 * strawberry_bushes >= 14)
m.addConstr(4 * vincas + 6 * cucumber_vines + 8 * strawberry_bushes >= 14)
m.addConstr(6 * cucumber_vines + 8 * strawberry_bushes + 3 * orange_trees >= 14)
m.addConstr(4 * vincas + 8 * strawberry_bushes + 3 * orange_trees >= 14)
m.addConstr(4 * vincas + 7 * zucchini_vines + 8 * strawberry_bushes >= 11)
m.addConstr(4 * vincas + 6 * cucumber_vines + 8 * strawberry_bushes >= 11)
m.addConstr(6 * cucumber_vines + 8 * strawberry_bushes + 3 * orange_trees >= 11)
m.addConstr(4 * vincas + 8 * strawberry_bushes + 3 * orange_trees >= 11)
m.addConstr(4 * vincas + 6 * cucumber_vines + 7 * zucchini_vines + 8 * strawberry_bushes + 3 * orange_trees >= 11)

m.addConstr(3 * vincas + 10 * zucchini_vines >= 25)
m.addConstr(3 * vincas + 5 * strawberry_bushes >= 46)
m.addConstr(3 * vincas + 5 * strawberry_bushes + 2 * orange_trees >= 33)
m.addConstr(3 * cucumber_vines + 10 * zucchini_vines + 2 * orange_trees >= 33)
m.addConstr(3 * vincas + 10 * zucchini_vines + 2 * orange_trees >= 33)
m.addConstr(10 * zucchini_vines + 5 * strawberry_bushes + 2 * orange_trees >= 33)
m.addConstr(3 * vincas + 10 * zucchini_vines + 5 * strawberry_bushes >= 33)
m.addConstr(3 * vincas + 3 * cucumber_vines + 10 * zucchini_vines >= 33)
m.addConstr(3 * cucumber_vines + 10 * zucchini_vines + 5 * strawberry_bushes >= 33)
m.addConstr(3 * vincas + 5 * strawberry_bushes + 2 * orange_trees >= 34)
m.addConstr(3 * cucumber_vines + 10 * zucchini_vines + 2 * orange_trees >= 34)
m.addConstr(3 * vincas + 10 * zucchini_vines + 2 * orange_trees >= 34)
m.addConstr(10 * zucchini_vines + 5 * strawberry_bushes + 2 * orange_trees >= 34)
m.addConstr(3 * vincas + 10 * zucchini_vines + 5 * strawberry_bushes >= 34)
m.addConstr(3 * vincas + 3 * cucumber_vines + 10 * zucchini_vines >= 34)
m.addConstr(3 * cucumber_vines + 10 * zucchini_vines + 5 * strawberry_bushes >= 34)


# ... (rest of the cost constraints)


m.addConstr(4 * cucumber_vines - orange_trees >= 0)
m.addConstr(4 * vincas + 6 * cucumber_vines + 3 * orange_trees <= 60)
m.addConstr(4 * vincas + 7 * zucchini_vines + 8 * strawberry_bushes <= 21)
m.addConstr(4 * vincas + 7 * zucchini_vines + 3 * orange_trees <= 42)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

