
from gurobipy import *

# Create a new model
m = Model("Vitamin_Mix")

# Define variables
x1 = m.addVar(name="vitamin_B9", lb=0)  # Milligrams of vitamin B9
x2 = m.addVar(name="vitamin_B6", lb=0)  # Milligrams of vitamin B6
x3 = m.addVar(name="vitamin_K", lb=0)   # Milligrams of vitamin K
x4 = m.addVar(name="iron", lb=0)        # Milligrams of iron
x5 = m.addVar(name="vitamin_B4", lb=0)  # Milligrams of vitamin B4
x6 = m.addVar(name="fiber", lb=0)       # Grams of fiber

# Objective function: Maximize the given expression
m.setObjective(54*x1 + 53*x2 + 52*x3 + 51*x4 + 50*x5 + 49*x6, GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x1 + 8*x4 + 7*x5 >= 85, name="cardiovascular_support")
m.addConstr(5*x2 - 8*x4 >= 0, name="vitamin_B6_iron_ratio")

# Add other constraints here as specified in the problem statement
# Example:
# m.addConstr(x1 + x2 <= 100, name="example_constraint")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
