
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
sys_admins = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")

# Set objective function
m.setObjective(8.84 * honeypots**2 + 8.8 * honeypots * sys_admins + 1.26 * honeypots * soc_operators + 2.7 * sys_admins**2 + 7.63 * sys_admins * soc_operators + 5.13 * soc_operators**2 + 7.0 * honeypots + 9.9 * sys_admins + 7.02 * soc_operators, GRB.MAXIMIZE)

# Add constraints
m.addConstr(honeypots + 2 * sys_admins + 4 * soc_operators <= 202, "Computational Load")  # r0
m.addConstr(5 * honeypots + 11 * sys_admins + 6 * soc_operators <= 79, "Data Integrity Impact")  # r1
m.addConstr(9 * honeypots + 5 * sys_admins + 7 * soc_operators <= 98, "Power Consumption")  # r2
m.addConstr(honeypots + 3 * sys_admins + 8 * soc_operators <= 62, "Data Accessibility Impact")  # r3
m.addConstr(2 * honeypots + 9 * sys_admins + 6 * soc_operators <= 48, "Network Integrity Impact")  # r4

m.addConstr(5 * honeypots + 6 * soc_operators >= 16, "Combined Data Integrity 1")
m.addConstr(9 * honeypots**2 + 7 * soc_operators**2 >= 20, "Power Consumption Squared")
m.addConstr(honeypots + 3 * sys_admins >= 15, "Combined Data Accessibility 1")
m.addConstr(9 * sys_admins + 6 * soc_operators >= 13, "Combined Network Integrity 1")
m.addConstr(2 * honeypots**2 + 9 * sys_admins**2 >= 7, "Combined Network Integrity Squared")
m.addConstr(4 * sys_admins**2 + 16 * soc_operators**2 <= 106, "Computational Load Squared")
m.addConstr(honeypots**2 + 4 * sys_admins**2 <= 133, "Computational Load Squared 2")
m.addConstr(honeypots + sys_admins + soc_operators <= 133, "Total Resources")
m.addConstr(5 * honeypots + 6 * soc_operators <= 47, "Combined Data Integrity 2")
m.addConstr(11 * sys_admins**2 + 6 * soc_operators**2 <= 49, "Combined Data Integrity Squared")
m.addConstr(5 * honeypots + 11 * sys_admins <= 33, "Combined Data Integrity 3")
m.addConstr(5 * honeypots + 11 * sys_admins + 6 * soc_operators <= 33, "Combined Data Integrity 4")
m.addConstr(5 * sys_admins + 7 * soc_operators <= 32, "Power Consumption 2")
m.addConstr(9 * honeypots + 7 * soc_operators <= 63, "Power Consumption 3")
m.addConstr(9 * honeypots + 5 * sys_admins + 7 * soc_operators <= 63, "Power Consumption 4")
m.addConstr(honeypots + 8 * soc_operators <= 53, "Combined Data Accessibility 2")
m.addConstr(honeypots**2 + 9 * sys_admins**2 <= 59, "Combined Data Accessibility Squared")
m.addConstr(honeypots + 3 * sys_admins + 8 * soc_operators <= 59, "Combined Data Accessibility 3")
m.addConstr(9 * sys_admins + 6 * soc_operators <= 18, "Combined Network Integrity 2")
m.addConstr(2 * honeypots + 9 * sys_admins <= 28, "Combined Network Integrity 3")
m.addConstr(2 * honeypots + 9 * sys_admins + 6 * soc_operators <= 28, "Combined Network Integrity 4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('honeypots:', honeypots.x)
    print('system_administrators:', sys_admins.x)
    print('SOC_operators:', soc_operators.x)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

