
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
h = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)
s = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
o = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8.84 * h**2 + 8.8 * h * s + 1.26 * h * o + 2.7 * s**2 + 7.63 * s * o + 5.13 * o**2 + 7.0 * h + 9.9 * s + 7.02 * o, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(h + 2 * s + 4 * o <= 202)  # computational load
m.addConstr(5 * h + 11 * s + 6 * o <= 79)  # data integrity impact
m.addConstr(9 * h + 5 * s + 7 * o <= 98)  # power consumption
m.addConstr(h + 3 * s + 8 * o <= 62)  # data accessibility impact
m.addConstr(2 * h + 9 * s + 6 * o <= 48)  # network integrity impact
m.addConstr(5 * h + 6 * o >= 16)  # combined data integrity impact from honeypots and SOC operators
m.addConstr(9 * h**2 + 7 * o**2 >= 20)  # power consumption from honeypots squared and SOC operators squared
m.addConstr(h + 3 * s >= 15)  # combined data accessibility impact from honeypots and system administrators
m.addConstr(9 * s + 6 * o >= 13)  # combined network integrity impact from system administrators and SOC operators
m.addConstr(4 * h**2 + 9 * s**2 >= 7)  # combined network integrity impact from honeypots squared and system administrators squared
m.addConstr(4 * s**2 + 16 * o**2 <= 106)  # computational load from system administrators squared and SOC operators squared
m.addConstr(h**2 + 4 * s**2 <= 133)  # computational load from honeypots squared and system administrators squared
m.addConstr(h + 2 * s + 4 * o <= 133)  # total computational load
m.addConstr(5 * h + 6 * o <= 47)  # combined data integrity impact from honeypots and SOC operators
m.addConstr(121 * s**2 + 36 * o**2 <= 49)  # combined data integrity impact from system administrators squared and SOC operators squared
m.addConstr(5 * h + 11 * s <= 33)  # combined data integrity impact from honeypots and system administrators
m.addConstr(5 * h + 11 * s + 6 * o <= 33)  # combined data integrity impact from honeypots, system administrators, and SOC operators
m.addConstr(5 * s + 7 * o <= 32)  # power consumption from system administrators and SOC operators
m.addConstr(9 * h + 7 * o <= 63)  # power consumption from honeypots and SOC operators
m.addConstr(9 * h + 5 * s + 7 * o <= 63)  # total power consumption
m.addConstr(h + 8 * o <= 53)  # combined data accessibility impact from honeypots and SOC operators
m.addConstr(h**2 + 9 * s**2 <= 59)  # combined data accessibility impact from honeypots squared and system administrators squared
m.addConstr(h + 3 * s + 8 * o <= 59)  # combined data accessibility impact from honeypots, system administrators, and SOC operators
m.addConstr(9 * s + 6 * o <= 18)  # combined network integrity impact from system administrators and SOC operators
m.addConstr(2 * h + 9 * s <= 28)  # combined network integrity impact from honeypots and system administrators
m.addConstr(2 * h + 9 * s + 6 * o <= 28)  # combined network integrity impact from honeypots, system administrators, and SOC operators

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Honeypots: ", h.varValue)
    print("System Administrators: ", s.varValue)
    print("SOC Operators: ", o.varValue)
else:
    print("The model is infeasible.")
