
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")

    # Set objective function
    m.setObjective(1*x0 + 4*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4.0*x0 + 0.84*x1 >= 39, "calcium_lower_bound")
    m.addConstr(12.96*x0 + 15.92*x1 >= 59, "sourness_lower_bound")
    m.addConstr(-5*x0 + 8*x1 >= 0, "additional_constraint")
    m.addConstr(4.0*x0 + 0.84*x1 <= 100, "calcium_upper_bound")
    m.addConstr(12.96*x0 + 15.92*x1 <= 80, "sourness_upper_bound")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bagged_salads:', x0.x)
        print('potatoes:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

