
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
bagged_salads = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")

# Set the objective function
m.setObjective(bagged_salads + 4 * potatoes, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.0 * bagged_salads + 0.84 * potatoes >= 39, "Calcium_Lower_Bound")
m.addConstr(4.0 * bagged_salads + 0.84 * potatoes <= 100, "Calcium_Upper_Bound")
m.addConstr(12.96 * bagged_salads + 15.92 * potatoes >= 59, "Sourness_Lower_Bound")
m.addConstr(12.96 * bagged_salads + 15.92 * potatoes <= 80, "Sourness_Upper_Bound")
m.addConstr(-5 * bagged_salads + 8 * potatoes >= 0, "Additional_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {bagged_salads.varName} = {bagged_salads.x}, {potatoes.varName} = {potatoes.x}")
else:
    print("No optimal solution found")
