
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bagged_salads = model.addVar(lb=0, name="bagged_salads", vtype=gurobi.GRB.CONTINUOUS)
    potatoes = model.addVar(lb=0, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(bagged_salads + 4 * potatoes, gurobi.GRB.MINIMIZE)

    # Constraints
    # Calcium constraint: 4.0 * bagged_salads + 0.84 * potatoes >= 39
    model.addConstr(4.0 * bagged_salads + 0.84 * potatoes >= 39, name="calcium_constraint")

    # Sourness index constraint: 12.96 * bagged_salads + 15.92 * potatoes >= 59
    model.addConstr(12.96 * bagged_salads + 15.92 * potatoes >= 59, name="sourness_index_constraint_min")

    # Sourness index constraint: 12.96 * bagged_salads + 15.92 * potatoes <= 80
    model.addConstr(12.96 * bagged_salads + 15.92 * potatoes <= 80, name="sourness_index_constraint_max")

    # Calcium upper bound constraint: 4.0 * bagged_salads + 0.84 * potatoes <= 100
    model.addConstr(4.0 * bagged_salads + 0.84 * potatoes <= 100, name="calcium_upper_bound")

    # Expression constraint: -5 * bagged_salads + 8 * potatoes >= 0
    model.addConstr(-5 * bagged_salads + 8 * potatoes >= 0, name="expression_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bagged Salads: {bagged_salads.varValue}")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimization_problem()
