
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource_Allocation")

# Create variables
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
bobby_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set objective function
model.setObjective(2.31 * dale_hours + 9.7 * bobby_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * dale_hours + 10 * bobby_hours >= 7, "computer_competence_min")
model.addConstr(11 * dale_hours + 6 * bobby_hours >= 20, "organization_score_min")
model.addConstr(11 * dale_hours + 11 * bobby_hours >= 9, "work_quality_min")
model.addConstr(-1 * dale_hours + 8 * bobby_hours >= 0, "dale_bobby_relation")

model.addConstr(4 * dale_hours + 10 * bobby_hours <= 16, "computer_competence_max") # Consolidated redundant constraints
model.addConstr(11 * dale_hours + 6 * bobby_hours <= 51, "organization_score_max") # Consolidated redundant constraints
model.addConstr(11 * dale_hours + 11 * bobby_hours <= 35, "work_quality_max") # Consolidated redundant constraints


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Hours worked by Dale: {dale_hours.x}")
    print(f"Hours worked by Bobby: {bobby_hours.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

