
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
D = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
B = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(2.31 * D + 9.7 * B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*D + 10*B >= 7, "computer_competence_min")
m.addConstr(4*D + 10*B <= 16, "computer_competence_max")
m.addConstr(11*D + 6*B >= 20, "organization_score_min")
m.addConstr(11*D + 6*B <= 51, "organization_score_max")
m.addConstr(11*D + 11*B >= 9, "work_quality_rating_min")
m.addConstr(11*D + 11*B <= 35, "work_quality_rating_max")
m.addConstr(-1*D + 8*B >= 0, "linear_combination")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Dale: {D.x}")
    print(f"Hours worked by Bobby: {B.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
