
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization Problem")

# Define variables
hours_Dale = m.addVar(name="hours_worked_by_Dale", lb=0)
hours_Bobby = m.addVar(name="hours_worked_by_Bobby", lb=0)

# Objective function
m.setObjective(2.31 * hours_Dale + 9.7 * hours_Bobby, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4 * hours_Dale <= 25, name="Dale_computer_competence")
m.addConstr(11 * hours_Dale <= 56, name="Dale_organization_score")
m.addConstr(11 * hours_Dale <= 49, name="Dale_work_quality_rating")

m.addConstr(10 * hours_Bobby <= 25, name="Bobby_computer_competence")
m.addConstr(6 * hours_Bobby <= 56, name="Bobby_organization_score")
m.addConstr(11 * hours_Bobby <= 49, name="Bobby_work_quality_rating")

m.addConstr(4 * hours_Dale + 10 * hours_Bobby >= 7, name="combined_computer_competence")
m.addConstr(11 * hours_Dale + 6 * hours_Bobby >= 20, name="combined_organization_score")
m.addConstr(11 * hours_Dale + 11 * hours_Bobby >= 9, name="combined_work_quality")

m.addConstr(-hours_Dale + 8 * hours_Bobby >= 0, name="hours_worked_constraint")

m.addConstr(4 * hours_Dale + 10 * hours_Bobby <= 16, name="combined_computer_competence_upper")
m.addConstr(11 * hours_Dale + 6 * hours_Bobby <= 51, name="combined_organization_score_upper")
m.addConstr(11 * hours_Dale + 11 * hours_Bobby <= 35, name="combined_work_quality_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Dale: {hours_Dale.varValue}")
    print(f"Hours worked by Bobby: {hours_Bobby.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
