
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(vtype=gp.GRB.INTEGER, name="bacon")
fruit_salad = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salad")
ham_sandwich = m.addVar(vtype=gp.GRB.INTEGER, name="ham_sandwich")

# Set objective function
m.setObjective(2 * bacon**2 + 5 * bacon * fruit_salad + fruit_salad**2 + fruit_salad * ham_sandwich + 9 * bacon + 7 * fruit_salad + ham_sandwich, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * fruit_salad**2 + 8 * ham_sandwich**2 >= 22, "c0")
m.addConstr(7 * bacon + 8 * ham_sandwich >= 22, "c1")
m.addConstr(7 * bacon + 8 * fruit_salad + 8 * ham_sandwich >= 22, "c2")
m.addConstr(3 * fruit_salad + 6 * ham_sandwich >= 8, "c3")
m.addConstr(7 * bacon**2 + 3 * fruit_salad**2 >= 20, "c4")
m.addConstr(7 * bacon + 3 * fruit_salad + 6 * ham_sandwich >= 20, "c5")
m.addConstr(2 * fruit_salad + 6 * ham_sandwich >= 18, "c6")
m.addConstr(8 * bacon**2 + 6 * ham_sandwich**2 >= 20, "c7")
m.addConstr(8 * bacon + 2 * fruit_salad + 6 * ham_sandwich >= 22, "c8")
m.addConstr(4 * fruit_salad - 5 * ham_sandwich >= 0, "c9")
m.addConstr(10 * bacon**2 - 5 * ham_sandwich**2 >= 0, "c10")
m.addConstr(7 * bacon + 8 * fruit_salad <= 74, "c11")
m.addConstr(8 * fruit_salad + 8 * ham_sandwich <= 75, "c12")
m.addConstr(7 * bacon + 6 * ham_sandwich <= 57, "c13")
m.addConstr(7 * bacon**2 + 3 * fruit_salad**2 + 6 * ham_sandwich**2 <= 53, "c14")


# Resource Constraints
m.addConstr(7 * bacon + 8 * fruit_salad + 8 * ham_sandwich <= 97, "fiber_constraint")
m.addConstr(7 * bacon + 3 * fruit_salad + 6 * ham_sandwich <= 69, "healthiness_constraint")
m.addConstr(8 * bacon + 2 * fruit_salad + 6 * ham_sandwich <= 66, "sourness_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bacon:', bacon.x)
    print('fruit_salad:', fruit_salad.x)
    print('ham_sandwich:', ham_sandwich.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
