
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pasta = m.addVar(lb=0, name="pasta")  # bowls of pasta (continuous)
apples = m.addVar(lb=0, name="apples") # apples (continuous)
hotdogs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hotdogs") # hot dogs (integer)

# Set objective function
m.setObjective(2 * pasta + 9 * apples + 5 * hotdogs, gp.GRB.MAXIMIZE)

# Add constraints

# Resource constraints (iron, carbs, fiber, cost)
m.addConstr(7 * pasta + 6 * apples + 9 * hotdogs <= 65, "iron_total")
m.addConstr(4 * pasta + 7 * apples + 7 * hotdogs <= 93, "carbs_total")
m.addConstr(11 * pasta + 7 * apples + 2 * hotdogs <= 130, "fiber_total")
m.addConstr(10 * pasta + 10 * apples + 7 * hotdogs <= 91, "cost_total")


# Additional constraints
m.addConstr(7 * pasta + 6 * apples + 9 * hotdogs >= 13, "iron_min")
m.addConstr(7 * apples + 7 * hotdogs >= 17, "carbs_apples_hotdogs_min")
m.addConstr(4 * pasta + 7 * hotdogs >= 15, "carbs_pasta_hotdogs_min")
m.addConstr(7 * apples + 2 * hotdogs >= 22, "fiber_apples_hotdogs_min")
m.addConstr(11 * pasta + 2 * hotdogs >= 18, "fiber_pasta_hotdogs_min")
m.addConstr(7 * pasta + 9 * hotdogs <= 25, "iron_pasta_hotdogs_max")
m.addConstr(7 * pasta + 6 * apples + 9 * hotdogs <= 25, "iron_total_max") # Redundant given iron_total
m.addConstr(4 * pasta + 7 * hotdogs <= 56, "carbs_pasta_hotdogs_max")
m.addConstr(7 * apples + 7 * hotdogs <= 83, "carbs_apples_hotdogs_max")
m.addConstr(4 * pasta + 7 * apples + 7 * hotdogs <= 93, "carbs_total_max") # Redundant given carbs_total
m.addConstr(11 * pasta + 2 * hotdogs <= 84, "fiber_pasta_hotdogs_max")
m.addConstr(11 * pasta + 7 * apples <= 100, "fiber_pasta_apples_max")
m.addConstr(11 * pasta + 7 * apples + 2 * hotdogs <= 100, "fiber_total_max") # Redundant given fiber_total
m.addConstr(10 * apples + 7 * hotdogs <= 73, "cost_apples_hotdogs_max")
m.addConstr(10 * pasta + 10 * apples + 7 * hotdogs <= 73, "cost_total_max") # Redundant given cost_total


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Pasta:', pasta.x)
    print('Apples:', apples.x)
    print('Hot dogs:', hotdogs.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

