
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
p = m.addVar(lb=0, name="bowls_of_pasta")  # Continuous variable for bowls of pasta
a = m.addVar(lb=0, name="apples")          # Continuous variable for apples
h = m.addVar(vtype=GRB.INTEGER, lb=0, name="hot_dogs")  # Integer variable for hot dogs

# Objective function: Maximize 2*p + 9*a + 5*h
m.setObjective(2*p + 9*a + 5*h, GRB.MAXIMIZE)

# Constraints
# Iron constraints
m.addConstr(p*7 + a*6 + h*9 >= 13, name="iron_min")  # At least 13 milligrams of iron
m.addConstr(p*7 + h*9 <= 25, name="iron_max_bowls_hotdogs")  # No more than 25 mg from bowls and hot dogs
m.addConstr(p*7 + a*6 + h*9 <= 65, name="total_iron_max")  # Total iron constraint

# Carbohydrates constraints
m.addConstr(a*7 + h*7 >= 17, name="carbs_min_apples_hotdogs")  # At least 17 grams from apples and hot dogs
m.addConstr(p*4 + h*7 >= 15, name="carbs_min_bowls_hotdogs")  # At least 15 grams from bowls and hot dogs
m.addConstr(p*4 + a*7 + h*7 <= 93, name="total_carbs_max")  # Total carbohydrates constraint

# Fiber constraints
m.addConstr(a*7 + h*2 >= 22, name="fiber_min_apples_hotdogs")  # At least 22 grams from apples and hot dogs
m.addConstr(p*11 + h*2 >= 18, name="fiber_min_bowls_hotdogs")  # At least 18 grams from bowls and hot dogs
m.addConstr(p*11 + a*7 <= 100, name="fiber_max_bowls_apples")  # No more than 100 grams from bowls and apples
m.addConstr(p*11 + h*2 <= 84, name="fiber_max_bowls_hotdogs")  # No more than 84 grams from bowls and hot dogs
m.addConstr(p*11 + a*7 + h*2 <= 130, name="total_fiber_max")  # Total fiber constraint

# Cost constraints
m.addConstr(a*10 + h*7 <= 73, name="cost_max_apples_hotdogs")  # Maximum cost for apples and hot dogs
m.addConstr(p*10 + a*10 + h*7 <= 91, name="total_cost_max")  # Total cost constraint

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bowls of pasta: {p.x}")
    print(f"Apples: {a.x}")
    print(f"Hot dogs: {h.x}")
else:
    print("No optimal solution found")
