
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="bowls_of_pasta", lb=0)  # No lower bound specified, assuming 0
x1 = m.addVar(name="apples", lb=0)  # No lower bound specified, assuming 0
x2 = m.addVar(name="hot_dogs", lb=0, integrality=gp.GRB.INTEGER)  # Must be an integer

# Objective function
m.setObjective(2*x0 + 9*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x0 + 6*x1 + 9*x2 >= 13, name="total_iron")
m.addConstr(7*x1 + 7*x2 >= 17, name="carbohydrates_from_apples_and_hot_dogs")
m.addConstr(4*x0 + 7*x2 >= 15, name="carbohydrates_from_bowls_of_pasta_and_hot_dogs")
m.addConstr(7*x1 + 2*x2 >= 22, name="fiber_from_apples_and_hot_dogs")
m.addConstr(11*x0 + 2*x2 >= 18, name="fiber_from_bowls_of_pasta_and_hot_dogs")
m.addConstr(7*x0 + 9*x2 <= 25, name="iron_from_bowls_of_pasta_and_hot_dogs")
m.addConstr(7*x0 + 6*x1 + 9*x2 <= 65, name="total_iron_upper_bound")
m.addConstr(4*x0 + 7*x2 <= 56, name="carbohydrates_from_bowls_of_pasta_and_hot_dogs_upper_bound")
m.addConstr(7*x1 + 7*x2 <= 83, name="carbohydrates_from_apples_and_hot_dogs_upper_bound")
m.addConstr(4*x0 + 7*x1 + 7*x2 <= 93, name="total_carbohydrates_upper_bound")
m.addConstr(11*x0 + 2*x2 <= 84, name="fiber_from_bowls_of_pasta_and_hot_dogs_upper_bound")
m.addConstr(11*x0 + 7*x1 <= 100, name="fiber_from_bowls_of_pasta_and_apples_upper_bound")
m.addConstr(11*x0 + 7*x1 + 2*x2 <= 130, name="total_fiber_upper_bound")
m.addConstr(10*x1 + 7*x2 <= 73, name="cost_of_apples_and_hot_dogs")
m.addConstr(10*x0 + 10*x1 + 7*x2 <= 91, name="total_cost")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Bowls of pasta: {x0.varValue}")
    print(f"Apples: {x1.varValue}")
    print(f"Hot dogs: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
