
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
soc_operators = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")
network_admins = m.addVar(vtype=GRB.INTEGER, name="Network_admins")

# Set objective function
m.setObjective(9 * soc_operators**2 + 6 * network_admins**2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.86 * soc_operators + 0.09 * network_admins >= 20, "min_network_latency")
m.addConstr((0.64 * soc_operators)**2 + (0.79 * network_admins)**2 >= 13, "min_data_accessibility_impact_squared")
m.addConstr(0.64 * soc_operators + 0.79 * network_admins >= 13, "min_data_accessibility_impact")
m.addConstr(0.34 * soc_operators + 0.12 * network_admins >= 23, "min_cost")
m.addConstr(7 * soc_operators**2 - 6 * network_admins**2 >= 0, "soc_admin_relationship")
m.addConstr((0.86 * soc_operators)**2 + (0.09 * network_admins)**2 <= 76, "max_network_latency_squared")
m.addConstr((0.64 * soc_operators)**2 + (0.79 * network_admins)**2 <= 32, "max_data_accessibility_impact_squared")
m.addConstr((0.34 * soc_operators)**2 + (0.12 * network_admins)**2 <= 68, "max_cost_squared")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('SOC operators:', soc_operators.x)
    print('Network administrators:', network_admins.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

