
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")
x1 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Objective function
m.setObjective(9*x0**2 + 6*x1**2, GRB.MINIMIZE)

# Constraints
m.addConstr(0.86*x0 + 0.09*x1 >= 20, "Network_Latency_Lower_Bound")
m.addConstr((0.64*x0)**2 + (0.79*x1)**2 >= 13, "Data_Accessibility_Impact_Squared_Lower_Bound")
m.addConstr(0.64*x0 + 0.79*x1 >= 13, "Data_Accessibility_Impact_Linear_Lower_Bound")
m.addConstr(0.34*x0 + 0.12*x1 >= 23, "Cost_Lower_Bound")
m.addConstr(7*x0**2 - 6*x1**2 >= 0, "Mixed_Constraint")
m.addConstr((0.86*x0)**2 + (0.09*x1)**2 <= 76, "Network_Latency_Upper_Bound")
m.addConstr((0.64*x0)**2 + (0.79*x1)**2 <= 32, "Data_Accessibility_Impact_Squared_Upper_Bound")
m.addConstr((0.34*x0)**2 + (0.12*x1)**2 <= 68, "Cost_Upper_Bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: x0 = {x0.x}, x1 = {x1.x}")
else:
    print("No optimal solution found")
