
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
SOC = m.addVar(name="SOC_operators", vtype=GRB.INTEGER)
Admin = m.addVar(name="network_administrators", vtype=GRB.INTEGER)

# Objective function
m.setObjective(9 * SOC**2 + 6 * Admin**2, GRB.MINIMIZE)

# Constraints
m.addConstr(0.86 * SOC + 0.09 * Admin >= 20, name="network_latency_constraint")
m.addConstr(0.64 * SOC + 0.79 * Admin >= 13, name="data_accessibility_constraint")
m.addConstr((0.64 * SOC)**2 + (0.79 * Admin)**2 <= 32, name="data_accessibility_squared_constraint")
m.addConstr(0.34 * SOC + 0.12 * Admin >= 23, name="cost_constraint")
m.addConstr(7 * SOC**2 - 6 * Admin**2 >= 0, name="additional_constraint_1")
m.addConstr((0.86 * SOC)**2 + (0.09 * Admin)**2 <= 76, name="network_latency_squared_constraint")
m.addConstr((0.34 * SOC + 0.12 * Admin)**2 <= 68, name="cost_squared_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"SOC operators: {SOC.varValue}")
    print(f"Network administrators: {Admin.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
