
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
hours = {}
workers = ['Jean', 'Bill', 'George', 'Mary', 'Bobby', 'Dale']
for i, worker in enumerate(workers):
    hours[worker] = m.addVar(lb=0, name=f"hours_{worker}")

# Set objective function
obj = 2.72 * hours['Jean'] + 7.57 * hours['Bill'] + 3.16 * hours['George'] + 7.71 * hours['Mary'] + 8.86 * hours['Bobby'] + 1.53 * hours['Dale']
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'dollar cost per hour', 'upper_bound': 872, 'Jean': 1.52, 'Bill': 3.77, 'George': 2.03, 'Mary': 0.63, 'Bobby': 0.36, 'Dale': 2.01}, 
            'r1': {'description': 'work quality rating', 'upper_bound': 413, 'Jean': 3.34, 'Bill': 1.65, 'George': 0.87, 'Mary': 0.8, 'Bobby': 1.07, 'Dale': 2.32}, 
            'r2': {'description': 'paperwork competence rating', 'upper_bound': 533, 'Jean': 3.35, 'Bill': 3.51, 'George': 3.55, 'Mary': 2.15, 'Bobby': 2.95, 'Dale': 2.94}, 
            'r3': {'description': 'productivity rating', 'upper_bound': 264, 'Jean': 2.17, 'Bill': 3.85, 'George': 1.45, 'Mary': 3.03, 'Bobby': 1.07, 'Dale': 3.57}}

# Add resource constraints (example for dollar cost)
m.addConstr(resources['r0']['Jean'] * hours['Jean'] + resources['r0']['Bill'] * hours['Bill'] + resources['r0']['George'] * hours['George'] + resources['r0']['Mary'] * hours['Mary'] + resources['r0']['Bobby'] * hours['Bobby'] + resources['r0']['Dale'] * hours['Dale'] <= resources['r0']['upper_bound'], "dollar_cost_constraint")

# Add other resource constraints similarly (r1, r2, r3)
for r_key, r_data in resources.items():
    if r_key != 'r0':  # Already added r0 constraint
        m.addConstr(sum(r_data[worker] * hours[worker] for worker in workers) <= r_data['upper_bound'], f"{r_data['description'].replace(' ', '_')}_constraint")


# Add specific constraints from the problem description
# (These are just a few examples, add all the constraints similarly)
m.addConstr(resources['r0']['Mary'] * hours['Mary'] + resources['r0']['Dale'] * hours['Dale'] >= 57)
m.addConstr(resources['r0']['Jean'] * hours['Jean'] + resources['r0']['Mary'] * hours['Mary'] >= 56)
m.addConstr(resources['r0']['Jean'] * hours['Jean'] + resources['r0']['George'] * hours['George'] >= 67)
# ... add all other constraints ...


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    for worker in workers:
        print(f'{worker} hours:', hours[worker].x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status:', m.status)

