
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Set objective function
m.setObjective(6*x0*x0 + 5*x0*x1 + 9*x1*x1 + 3*x1*x2 + 6*x2*x2 + 1*x0, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.32*x0 + 1.72*x2 <= 26, "c1")
m.addConstr(2.32*x0 + 4.68*x1 <= 17, "c2")
m.addConstr(2.32*x0 + 4.68*x1 + 1.72*x2 <= 17, "c3")
m.addConstr(4.38*x1*x1 + 2.0*x2*x2 <= 35, "c4")
m.addConstr(4.51*x0 + 2.0*x2 <= 29, "c5")
m.addConstr(4.51*x0 + 4.38*x1 + 2.0*x2 <= 29, "c6")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

