
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Objective function
m.setObjective(6*x0**2 + 5*x0*x1 + 9*x1**2 + 3*x1*x2 + 6*x2**2 + x0, GRB.MAXIMIZE)

# Constraints
# Logistical capacity constraints
m.addConstr(2.32*x0 + 4.68*x1 + 1.72*x2 <= 17, "log_cap_total")
m.addConstr(2.32*x0 + 1.72*x2 <= 26, "log_cap_recon_med")
m.addConstr(2.32*x0 + 4.68*x1 <= 17, "log_cap_recon_log")

# Deployment weight constraints
m.addConstr(4.51*x0 + 4.38*x1 + 2.0*x2 <= 29, "deploy_weight_total")
m.addConstr(4.51*x0 + 2.0*x2 <= 29, "deploy_weight_recon_med")
m.addConstr(4.38*x1**2 + 2.0*x2**2 <= 35, "deploy_weight_log_med")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance Troops: {x0.x}")
    print(f"Logistics Companies: {x1.x}")
    print(f"Medical Platoons: {x2.x}")
else:
    print("No optimal solution found.")
