
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define variables
reconnaissance_troops = m.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)
logistics_companies = m.addVar(name="logistics_companies", vtype=gp.GRB.INTEGER)
medical_platoons = m.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6 * reconnaissance_troops**2 + 5 * reconnaissance_troops * logistics_companies + 
               9 * logistics_companies**2 + 3 * logistics_companies * medical_platoons + 
               6 * medical_platoons**2 + reconnaissance_troops, gp.GRB.MAXIMIZE)

# Logistical capacity constraints
m.addConstr(2.32 * reconnaissance_troops <= 47, name="reconnaissance_troops_logistical_capacity")
m.addConstr(4.68 * logistics_companies <= 47, name="logistics_companies_logistical_capacity")
m.addConstr(1.72 * medical_platoons <= 47, name="medical_platoons_logistical_capacity")
m.addConstr(2.32 * reconnaissance_troops + 1.72 * medical_platoons <= 26, name="combined_reconnaissance_medical_logistical_capacity")
m.addConstr(2.32 * reconnaissance_troops + 4.68 * logistics_companies <= 17, name="combined_reconnaissance_logistics_logistical_capacity")
m.addConstr(2.32 * reconnaissance_troops + 4.68 * logistics_companies + 1.72 * medical_platoons <= 17, name="total_logistical_capacity")

# Deployment weight constraints
m.addConstr((4.38 * logistics_companies)**2 + (2.0 * medical_platoons)**2 <= 35, name="logistics_medical_deployment_weight")
m.addConstr(4.51 * reconnaissance_troops + 2.0 * medical_platoons <= 29, name="reconnaissance_medical_deployment_weight")
m.addConstr(4.51 * reconnaissance_troops + 4.38 * logistics_companies + 2.0 * medical_platoons <= 29, name="total_deployment_weight")

# Non-negativity constraints
m.addConstr(reconnaissance_troops >= 0, name="reconnaissance_troops_non_negativity")
m.addConstr(logistics_companies >= 0, name="logistics_companies_non_negativity")
m.addConstr(medical_platoons >= 0, name="medical_platoons_non_negativity")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Reconnaissance Troops: {reconnaissance_troops.varValue}")
    print(f"Logistics Companies: {logistics_companies.varValue}")
    print(f"Medical Platoons: {medical_platoons.varValue}")
    print(f"Objective Value: {m.objVal}")
else:
    print("No optimal solution found.")
