
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams_of_fiber", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B9", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams_of_protein", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(9.54 * x0 + 4.75 * x1 + 3.24 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.04 * x0 + 0.49 * x1 >= 117, name="immune_support_index_fiber_B9")
    model.addConstr(1.04 * x0 + 0.26 * x2 >= 109, name="immune_support_index_fiber_protein")
    model.addConstr(1.04 * x0 + 0.49 * x1 + 0.26 * x2 >= 109, name="immune_support_index_all")

    model.addConstr(2.48 * x0 + 0.8 * x2 >= 93, name="energy_stability_index_fiber_protein")
    model.addConstr(2.48 * x0 + 0.03 * x1 >= 46, name="energy_stability_index_fiber_B9")
    model.addConstr(2.48 * x0 + 0.03 * x1 + 0.8 * x2 >= 46, name="energy_stability_index_all")

    model.addConstr(0.44 * x0 + 2.45 * x2 >= 85, name="cognitive_performance_index_fiber_protein")
    model.addConstr(0.44 * x0 + 0.64 * x1 >= 34, name="cognitive_performance_index_fiber_B9")
    model.addConstr(0.44 * x0 + 0.64 * x1 + 2.45 * x2 >= 34, name="cognitive_performance_index_all")

    model.addConstr(6 * x1 - 8 * x2 >= 0, name="linear_constraint_B9_protein")
    model.addConstr(2 * x0 - 3 * x1 >= 0, name="linear_constraint_fiber_B9")

    model.addConstr(0.49 * x1 + 0.26 * x2 <= 148, name="upper_bound_B9_protein")
    model.addConstr(0.44 * x0 + 0.64 * x1 <= 156, name="upper_bound_fiber_B9")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Grams of fiber: ", x0.varValue)
        print("Milligrams of vitamin B9: ", x1.varValue)
        print("Grams of protein: ", x2.varValue)
    else:
        print("No optimal solution found.")

optimize()
