
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_c")
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
vitamin_b3 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b3")

# Set objective function
model.setObjective(6 * vitamin_c + 6 * fiber + 2 * vitamin_b3, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * vitamin_c + 5 * fiber >= 14, "c1")
model.addConstr(5 * fiber + 1 * vitamin_b3 >= 7, "c2")
model.addConstr(4 * vitamin_c + 5 * fiber + 1 * vitamin_b3 >= 17, "c3")
model.addConstr(-7 * fiber + 7 * vitamin_b3 >= 0, "c4")
model.addConstr(-5 * vitamin_c + 1 * vitamin_b3 >= 0, "c5")
model.addConstr(-1 * vitamin_c + 10 * fiber >= 0, "c6")
model.addConstr(5 * fiber + 1 * vitamin_b3 <= 26, "c7")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"  Vitamin C: {vitamin_c.x}")
    print(f"  Fiber: {fiber.x}")
    print(f"  Vitamin B3: {vitamin_b3.x}")
    print(f"  Objective Value: {model.objVal}")

