
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B3")

# Define the objective function
m.setObjective(6*x0 + 6*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + 5*x1 >= 14, name="cognitive_performance_index_1")
m.addConstr(5*x1 + x2 >= 7, name="cognitive_performance_index_2")
m.addConstr(4*x0 + 5*x1 + x2 >= 17, name="total_cognitive_performance_index")
m.addConstr(-7*x1 + 7*x2 >= 0, name="fiber_vitamin_b3_constraint")
m.addConstr(-5*x0 + x2 >= 0, name="vitamin_c_vitamin_b3_constraint")
m.addConstr(-x0 + 10*x1 >= 0, name="vitamin_c_fiber_constraint")
m.addConstr(5*x1 + x2 <= 26, name="upper_bound_cognitive_performance_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin C: {x0.x}")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Milligrams of Vitamin B3: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
