
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_C = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_C")
    fiber = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="fiber")
    vitamin_B3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="vitamin_B3")

    # Objective function
    model.setObjective(6 * vitamin_C + 6 * fiber + 2 * vitamin_B3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * vitamin_C + 5 * fiber >= 14, name="cognitive_performance_vitamin_C_fiber")
    model.addConstr(5 * fiber + vitamin_B3 >= 7, name="cognitive_performance_fiber_B3")
    model.addConstr(4 * vitamin_C + 5 * fiber + vitamin_B3 >= 17, name="cognitive_performance_total")
    model.addConstr(-7 * fiber + 7 * vitamin_B3 >= 0, name="fiber_B3_balance")
    model.addConstr(-5 * vitamin_C + vitamin_B3 >= 0, name="vitamin_C_B3_balance")
    model.addConstr(-vitamin_C + 10 * fiber >= 0, name="vitamin_C_fiber_balance")
    model.addConstr(5 * fiber + vitamin_B3 <= 26, name="cognitive_performance_fiber_B3_max")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {vitamin_C.x}")
        print(f"Grams of fiber: {fiber.x}")
        print(f"Milligrams of vitamin B3: {vitamin_B3.x}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_vitamins()
