
from gurobipy import Model, GRB

# Create a new model
m = Model("PlantOptimization")

# Create variables
agave = m.addVar(vtype=GRB.INTEGER, name="agave")
chives = m.addVar(vtype=GRB.INTEGER, name="chives")
boxwoods = m.addVar(vtype=GRB.INTEGER, name="boxwoods")

# Set objective function
m.setObjective(5 * agave + 3 * chives + 5 * boxwoods, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * agave + 5 * chives >= 3, "c1")  # Combined growth speed (agave, chives)
m.addConstr(3 * agave + 5 * chives + 2 * boxwoods >= 4, "c2")  # Combined growth speed (all)
m.addConstr(5 * agave + 1 * chives >= 24, "c3")  # Water need (agave, chives)
m.addConstr(1 * chives + 3 * boxwoods >= 20, "c4")  # Water need (chives, boxwoods)
m.addConstr(5 * agave + 3 * boxwoods >= 15, "c5")  # Water need (agave, boxwoods)
m.addConstr(5 * agave + 1 * chives + 3 * boxwoods >= 19, "c6")  # Water need (all)
m.addConstr(2 * chives + 4 * boxwoods >= 13, "c7")  # Cost (chives, boxwoods)

m.addConstr(3 * agave + 5 * chives <= 27, "c8")  # Combined growth speed (agave, chives) - upper bound
m.addConstr(5 * chives + 2 * boxwoods <= 10, "c9")  # Combined growth speed (chives, boxwoods) - upper bound
m.addConstr(3 * agave + 5 * chives + 2 * boxwoods <= 20, "c10")  # Combined growth speed (all) - upper bound
m.addConstr(5 * agave + 1 * chives <= 70, "c11")  # Water need (agave, chives) - upper bound
m.addConstr(1 * chives + 3 * boxwoods <= 95, "c12")  # Water need (chives, boxwoods) - upper bound
m.addConstr(5 * agave + 3 * boxwoods <= 47, "c13")  # Water need (agave, boxwoods) - upper bound
m.addConstr(5 * agave + 1 * chives + 3 * boxwoods <= 47, "c14")  # Water need (all) - upper bound
m.addConstr(4 * agave + 4 * boxwoods <= 36, "c15")  # Cost (agave, boxwoods) - upper bound
m.addConstr(2 * chives + 4 * boxwoods <= 27, "c16")  # Cost (chives, boxwoods) - upper bound
m.addConstr(4 * agave + 2 * chives + 4 * boxwoods <= 27, "c17")  # Cost (all) - upper bound


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('agave:', agave.x)
    print('chives:', chives.x)
    print('boxwoods:', boxwoods.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

