
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
agave = m.addVar(vtype=gurobi.GRB.INTEGER, name="agave")
chives = m.addVar(vtype=gurobi.GRB.INTEGER, name="chives")
boxwoods = m.addVar(vtype=gurobi.GRB.INTEGER, name="boxwoods")

# Objective function: maximize 5 * agave + 3 * chives + 5 * boxwoods
m.setObjective(5 * agave + 3 * chives + 5 * boxwoods, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3 * agave + 5 * chives >= 3, name="growth_speed_agave_chives_min")
m.addConstr(3 * agave + 5 * chives + 2 * boxwoods >= 4, name="growth_speed_total_min")
m.addConstr(5 * agave + chives >= 24, name="water_need_agave_chives_min")
m.addConstr(chives + 3 * boxwoods >= 20, name="water_need_chives_boxwoods_min")
m.addConstr(5 * agave + 3 * boxwoods >= 15, name="water_need_agave_boxwoods_min")
m.addConstr(5 * agave + chives + 3 * boxwoods >= 19, name="water_need_total_min")
m.addConstr(2 * chives + 4 * boxwoods >= 13, name="cost_chives_boxwoods_min")
m.addConstr(3 * agave + 5 * chives <= 27, name="growth_speed_agave_chives_max")
m.addConstr(5 * chives + 2 * boxwoods <= 10, name="growth_speed_chives_boxwoods_max")
m.addConstr(3 * agave + 5 * chives + 2 * boxwoods <= 20, name="growth_speed_total_max")
m.addConstr(5 * agave + chives <= 70, name="water_need_agave_chives_max")
m.addConstr(chives + 3 * boxwoods <= 95, name="water_need_chives_boxwoods_max")
m.addConstr(5 * agave + 3 * boxwoods <= 47, name="water_need_agave_boxwoods_max")
m.addConstr(5 * agave + chives + 3 * boxwoods <= 47, name="water_need_total_max")
m.addConstr(4 * agave + 4 * boxwoods <= 36, name="cost_agave_boxwoods_max")
m.addConstr(2 * chives + 4 * boxwoods <= 27, name="cost_chives_boxwoods_max")
m.addConstr(4 * agave + 2 * chives + 4 * boxwoods <= 27, name="cost_total_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Agave: {agave.varValue}")
    print(f"Chives: {chives.varValue}")
    print(f"Boxwoods: {boxwoods.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
