
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_zinc_optimization")

# Create variables
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")

# Set objective function
model.setObjective(1.63 * vitamin_e + 8.5 * zinc, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.6 * vitamin_e + 1.85 * zinc >= 21, "muscle_growth_min")
model.addConstr(1.24 * vitamin_e + 1.83 * zinc >= 21, "immune_support_min")
model.addConstr(7 * vitamin_e - 5 * zinc >= 0, "vitamin_zinc_relation")
model.addConstr(0.6 * vitamin_e + 1.85 * zinc <= 33, "muscle_growth_max")
model.addConstr(1.24 * vitamin_e + 1.83 * zinc <= 26, "immune_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of Vitamin E: {vitamin_e.x}")
    print(f"Milligrams of Zinc: {zinc.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

