
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_E")
x1 = m.addVar(lb=0, name="milligrams_of_zinc")

# Objective function: Minimize 1.63*x0 + 8.5*x1
m.setObjective(1.63*x0 + 8.5*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(0.6*x0 + 1.85*x1 >= 21, name="muscle_growth_index_min")
m.addConstr(0.6*x0 + 1.85*x1 <= 33, name="muscle_growth_index_max")
m.addConstr(1.24*x0 + 1.83*x1 >= 21, name="immune_support_index_min")
m.addConstr(1.24*x0 + 1.83*x1 <= 26, name="immune_support_index_max")
m.addConstr(7*x0 - 5*x1 >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Milligrams of Zinc: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
