
import gurobipy as gp

# Create a new model
model = gp.Model("Optimization_Problem")

# Define the variables
vitamin_E = model.addVar(name="vitamin_E", lb=0)  # Assuming non-negative
zinc = model.addVar(name="zinc", lb=0)  # Assuming non-negative

# Define the objective function
model.setObjective(1.63 * vitamin_E + 8.5 * zinc, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.6 * vitamin_E + 1.85 * zinc >= 21, name="muscle_growth_index")
model.addConstr(1.24 * vitamin_E + 1.83 * zinc >= 21, name="immune_support_index")
model.addConstr(7 * vitamin_E - 5 * zinc >= 0, name="vitamin_E_zinc_relation")
model.addConstr(0.6 * vitamin_E + 1.85 * zinc <= 33, name="muscle_growth_index_upper_bound")
model.addConstr(1.24 * vitamin_E + 1.83 * zinc <= 26, name="immune_support_index_upper_bound")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Vitamin E: {vitamin_E.varValue}")
    print(f"Milligrams of Zinc: {zinc.varValue}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
