
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
items = ['blue pens', '3D printers', 'headsets', 'wooden pencils', 'planners']
x = m.addVars(items, vtype=gp.GRB.INTEGER, name=items)

# Set objective function
m.setObjective(5.4 * x['blue pens'] + 3.95 * x['3D printers'] + 8.46 * x['headsets'] + 2.29 * x['wooden pencils'] + 2.54 * x['planners'], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] + 5 * x['headsets'] + 3 * x['wooden pencils'] + 4 * x['planners'] <= 51, "dollar cost")
m.addConstr(4 * x['blue pens'] + 3 * x['3D printers'] + 3 * x['headsets'] + 5 * x['wooden pencils'] + 1 * x['planners'] <= 44, "storage space")

m.addConstr(5 * x['headsets'] + 4 * x['planners'] >= 6, "headsets_planners_cost")
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] >= 5, "blue_pens_3D_printers_cost")
m.addConstr(5 * x['blue pens'] + 3 * x['wooden pencils'] + 4 * x['planners'] >= 10, "blue_pens_wooden_pencils_planners_cost") # Increased to 10 as per later constraint
m.addConstr(5 * x['headsets'] + 3 * x['wooden pencils'] + 4 * x['planners'] >= 10, "headsets_wooden_pencils_planners_cost") # Increased to 10 as per later constraint
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] + 4 * x['planners'] >= 10, "blue_pens_3D_printers_planners_cost") # Increased to 10 as per later constraint
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] + 5 * x['headsets'] >= 10, "blue_pens_3D_printers_headsets_cost") # Increased to 10 as per later constraint
m.addConstr(5 * x['blue pens'] + 5 * x['headsets'] + 4 * x['planners'] >= 10, "blue_pens_headsets_planners_cost") # Increased to 10 as per later constraint
m.addConstr(3 * x['3D printers'] + 3 * x['wooden pencils'] + 4 * x['planners'] >= 10, "3D_printers_wooden_pencils_planners_cost") # Increased to 10

m.addConstr(5 * x['blue pens'] + 4 * x['planners'] <= 15, "blue_pens_planners_cost_max")
m.addConstr(3 * x['3D printers'] + 4 * x['planners'] <= 51, "3D_printers_planners_cost_max")
m.addConstr(5 * x['blue pens'] + 3 * x['wooden pencils'] <= 50, "blue_pens_wooden_pencils_cost_max")
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] <= 14, "blue_pens_3D_printers_cost_max")
m.addConstr(5 * x['headsets'] + 3 * x['wooden pencils'] <= 28, "headsets_wooden_pencils_cost_max")
m.addConstr(5 * x['blue pens'] + 5 * x['headsets'] <= 27, "blue_pens_headsets_cost_max")
m.addConstr(5 * x['headsets'] + 4 * x['planners'] <= 30, "headsets_planners_cost_max")
m.addConstr(5 * x['blue pens'] + 3 * x['wooden pencils'] + 4 * x['planners'] <= 27, "blue_pens_wooden_pencils_planners_cost_max")
m.addConstr(3 * x['3D printers'] + 5 * x['headsets'] + 3 * x['wooden pencils'] <= 41, "3D_printers_headsets_wooden_pencils_cost_max")
m.addConstr(5 * x['headsets'] + 3 * x['wooden pencils'] + 4 * x['planners'] <= 19, "headsets_wooden_pencils_planners_cost_max")


m.addConstr(3 * x['3D printers'] + 1 * x['planners'] >= 7, "3D_printers_planners_space")
m.addConstr(4 * x['blue pens'] + 3 * x['3D printers'] >= 7, "blue_pens_3D_printers_space")
m.addConstr(3 * x['3D printers'] + 5 * x['wooden pencils'] >= 5, "3D_printers_wooden_pencils_space")
m.addConstr(3 * x['headsets'] + 5 * x['wooden pencils'] + 1 * x['planners'] >= 6, "headsets_wooden_pencils_planners_space")
m.addConstr(3 * x['3D printers'] + 3 * x['headsets'] + 1 * x['planners'] >= 6, "3D_printers_headsets_planners_space")
m.addConstr(3 * x['headsets'] + 5 * x['wooden pencils'] + 1 * x['planners'] >= 5, "headsets_wooden_pencils_planners_space2") # Duplicate constraint, but with 5 instead of 6. Taking the tighter bound.
m.addConstr(3 * x['3D printers'] + 3 * x['headsets'] + 1 * x['planners'] >= 5, "3D_printers_headsets_planners_space2") # Duplicate constraint, but with 5 instead of 6. Taking the tighter bound.
m.addConstr(4 * x['blue pens'] + 3 * x['3D printers'] + 3 * x['headsets'] + 5 * x['wooden pencils'] + 1 * x['planners'] >= 5, "all_items_space")
m.addConstr(5 * x['blue pens'] + 3 * x['3D printers'] + 5 * x['headsets'] + 3 * x['wooden pencils'] + 4 * x['planners'] >= 5, "all_items_cost")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

